#include "QrfeRfeAboutDialog.h"

#ifdef QRFE_RESOURCE
#include <QrfeResourceGlobal>
#endif

QrfeRfeAboutDialog::QrfeRfeAboutDialog(const QString& applicationName, const QString& version, QWidget *parent)
    : QDialog(parent)
{
	ui.setupUi(this);

	ui.applicationNameLabel->setText(applicationName);
	ui.versionLabel->setText(tr("Version ") + version);
	ui.licenseBox->setVisible(false);

#ifdef QRFE_RESOURCE
	QStringList licenses;
	licenses << QrfeGlobal::buttonLicenseStrings();
	ui.licenseLabel->setText(licenses.join("\n\n"));
	ui.licenseBox->setVisible(true);
#endif

	this->resize(0,0);
}

QrfeRfeAboutDialog::QrfeRfeAboutDialog(const QString& applicationName, const QString& version, const QStringList& licenses, QWidget *parent)
    : QDialog(parent)
{
	ui.setupUi(this);

	ui.applicationNameLabel->setText(applicationName);
	ui.versionLabel->setText(tr("Version ") + version);
	ui.licenseBox->setVisible(true);

#ifdef QRFE_RESOURCE
	QStringList allLicenses;
	allLicenses << licenses;
	allLicenses << QrfeGlobal::buttonLicenseStrings();
	ui.licenseLabel->setText(allLicenses.join("\n\n"));
#else
	ui.licenseLabel->setText(licenses.join("\n\n"));
#endif

	this->resize(0,0);
}


QrfeRfeAboutDialog::~QrfeRfeAboutDialog()
{

}
